{*
 * Projecte Fressa a LINKAT
 * GLOBUS3
 *
 * @author Jordi Lagares Roset "jlagares@xtec.cat - www.lagares.org"
 * amb el suport del Departament d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 *}

unit UnitFormSonograma;

{************************************************}
INTERFACE
{************************************************}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ToolWin, ComCtrls, MMSystem, ExtCtrls, StdCtrls, Spin, UnitDades, UnitCalculsLPC;

type
  TFormSonograma = class(TForm)
    Panel: TPanel;
    SpeedButtonEngegarParar: TSpeedButton;
    SpeedButtonEngegarPararGlobus: TSpeedButton;
    SpeedButtonCopiarALaCarpeta: TSpeedButton;
    CheckBoxCircular: TCheckBox;
    CheckBoxEscalaY: TCheckBox;
    Panel1: TPanel;
    StaticTextFrequenciaMouseMove: TStaticText;
    StaticTextNotaMouseMove: TStaticText;
    SpinEditVelocitat: TSpinEdit;
    LabelVelocitat: TLabel;
    SpinEditNumeroQuoeficients: TSpinEdit;
    LabelNumeroQuoeficientsLPC: TLabel;
    ButtonGuardarPista1: TSpeedButton;
    SpeedButtonObrir1: TSpeedButton;
    ButtonGuardarPista2: TSpeedButton;
    SaveDialog: TSaveDialog;
    OpenDialog: TOpenDialog;
    Bevel1: TBevel;
    Bevel2: TBevel;
    SpeedButtonCaixaEines: TSpeedButton;
    SpeedButtonObrir2: TSpeedButton;
    procedure FormPaint(Sender: TObject);
    procedure SpeedButtonEngegarPararClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure SpeedButtonEngegarPararGlobusClick(Sender: TObject);
    procedure SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
    procedure CheckBoxEscalaYClick(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer);
    procedure CheckBoxCircularClick(Sender: TObject);
    procedure SpinEditVelocitatChange(Sender: TObject);
    procedure SpinEditNumeroQuoeficientsChange(Sender: TObject);
    procedure ButtonGuardarPista1Click(Sender: TObject);
    procedure ButtonGuardarPista2Click(Sender: TObject);
    procedure SpeedButtonObrir1Click(Sender: TObject);
    procedure SpeedButtonCaixaEinesClick(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;Shift: TShiftState; X, Y: Integer);
    procedure SpeedButtonObrir2Click(Sender: TObject);
  private
    { Private declarations }
    procedure WMWIMDATA(var Msg: TMessage); message MM_WIM_DATA;
    procedure GuardarPista(Pista:integer);
    procedure ObrirPista(Pista:integer);
    Procedure PintarEjes;
  public
    { Public declarations }
    Comptador:integer;
    ComptadorPosicio:integer;
    ValorMaximDelSo:integer;
    YComenssaEspectroscopi:integer;
    NumeroDeDadesInicialsLPC:integer;
    NumerosEspectre:Integer;
    NumeroQuoeficientsLPC:integer;
    NumeroPuntsFuncioDeTransferencia:integer;
    Arrenco:integer;
    HertzUnPuntEspectroscopi:single;
    Temps:LongInt;
    HeDeRepintar:Boolean;
    HeDeReCalcularLPC:Boolean;
    NumerosPerCalcularFFT:NumerosPerCalcular;
    NumerosPerCalcularLPC:NumerosEntradaLPC;
    FuncioDeTransferenciaLPCX,FuncioDeTransferenciaLPCY:NumerosPerCalcular;
    ValorMinimDeSo:integer;
    Titol:array[1..2] of string;
  end;

var
  FormSonograma: TFormSonograma;

{************************************************}
IMPLEMENTATION
{************************************************}

uses UnitEntradaDeSo, UnitDadesGlobus2, UnitCalculFFT, UnitTools, UnitCalculsMatematics,
  Unitabout, UnitFormPrincipal, UnitCanviDeParametres;

{$R *.DFM}

const
  NumeroInstants = 1600;
  MaximGrandariaInstant = 512;
  MaximNumerosTotElSo = NumeroInstants*MaximGrandariaInstant;

var
  InstantActual:integer=0;
  GrandariaInstant:integer=512;
  //GrandariaInstant:integer=256;
  //IntervalEntreInstants:integer=32;
  IntervalEntreInstants:integer=64;
  QuinSo:integer;
  TotElSo:array[1..2,-MaximGrandariaInstant..MaximNumerosTotElSo] of integer;
  EspectreY:array[1..2,0..NumeroInstants,1..MaximNumerosBufferEntradaDeSo] of single;
  HiHaSo:array[1..2,0..NumeroInstants] of integer;
  NumeroPunts:integer;

var
  Pens: array[0..255] of HPen;
  PenVermell,PenGris: HPen;

{************************************************}
procedure TFormSonograma.FormCreate(Sender: TObject);
var
  i,n,k:LongInt;
begin
  for i:=-MaximGrandariaInstant to MaximNumerosTotElSo do begin
    TotElSo[1,i]:=0;
    TotElSo[2,i]:=0;
  end;
  for i:=0 to NumeroInstants do begin
    HiHaSo[1,i]:=0;
    HiHaSo[2,i]:=0;
    for n:=1 to MaximNumerosBufferEntradaDeSo do for k:=1 to 2 do EspectreY[k,i,n]:=0;
  end;
  YComenssaEspectroscopi:=38;
  NumeroDeDadesInicialsLPC:=GrandariaInstant;
  NumerosEspectre:=256;
  NumeroPuntsFuncioDeTransferencia:=NumerosEspectre;
  Arrenco:=0;
  FrequenciaDeMostreigEntradaSo:=11025;
  ComptadorPosicio:=0;
  Comptador:=0;
  NumeroQuoeficientsLPC:=SpinEditNumeroQuoeficients.Value;
  HertzUnPuntEspectroscopi:=FrequenciaDeMostreigEntradaSo/511;
  //for i:=0 to 255 do Pens[i]:=CreatePen(ps_Solid,0,RGB(i,i,i));
  for i:=0 to 255 do Pens[i]:=CreatePen(ps_Solid,0,RGB(255-i,255-i,255-i));
  PenVermell:=CreatePen(ps_Solid,0,ClRed);
  PenGris:=CreatePen(ps_Solid,0,ClGray);
  Canvas.Font.Color:=ClGray;
  Canvas.Brush.Style:=bsClear;
  NumeroPunts:=1600;
  if Screen.Width-1<NumeroPunts then NumeroPunts:=Screen.Width-1;
  HeDeRepintar:=true;
  HeDeReCalcularLPC:=true;
  ValorMinimDeSo:=5*256;
  Titol[1]:='';
  Titol[2]:='';
end;

procedure TFormSonograma.FormClose(Sender: TObject;var Action: TCloseAction);
begin
  if SpeedButtonEngegarParar.Down or SpeedButtonEngegarPararGlobus.Down then begin
    FinalitzarEntradaDeSo;
    SpeedButtonEngegarParar.Caption:='E';
    SpeedButtonEngegarParar.Down:=false;
    SpeedButtonEngegarParar.Enabled:=true;
    SpeedButtonEngegarPararGlobus.Caption:='EG';
    SpeedButtonEngegarPararGlobus.Down:=false;
    SpeedButtonEngegarPararGlobus.Enabled:=true;
    SpinEditVelocitat.Enabled:=true;
    SpinEditNumeroQuoeficients.Enabled:=true;
  end;
end;

procedure TFormSonograma.SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
var
  Rect:TRect;
begin
  Rect.Left:=0;
  Rect.Top:=Panel.Height;
  Rect.Right:=ClientRect.Right;
  Rect.Bottom:=YComenssaEspectroscopi+2+256*2;
  CopiarPartDeLaFinestraALaCarpeta(Handle,Rect);
end;

{************************************************}

Procedure TFormSonograma.PintarEjes;
var
  i,Comodi:integer;
begin
  if Titol[1]<>'' then Canvas.TextOut(35,42,Titol[1]);
  if Titol[2]<>'' then Canvas.TextOut(35,43+256,Titol[2]);
  if CheckBoxEscalaY.Checked then begin
    Canvas.Pen.Color:=ClGray;
    Comodi:=YComenssaEspectroscopi+255;
    i:=5000;
    While i>500 do begin
      Canvas.MoveTo(0,Comodi-Round(i/HertzUnPuntEspectroscopi));
      Canvas.LineTo(width,Comodi-Round(i/HertzUnPuntEspectroscopi));
      Canvas.TextOut(3,Comodi-12-Round(i/HertzUnPuntEspectroscopi),IntToStr(i));
      i:=i-1000;
    end;
    Comodi:=YComenssaEspectroscopi+257+255;
    i:=5000;
    While i>500 do begin
      Canvas.MoveTo(0,Comodi-Round(i/HertzUnPuntEspectroscopi));
      Canvas.LineTo(width,Comodi-Round(i/HertzUnPuntEspectroscopi));
      Canvas.TextOut(3,Comodi-12-Round(i/HertzUnPuntEspectroscopi),IntToStr(i));
      i:=i-1000;
    end;
  end;
end;

procedure TFormSonograma.SpeedButtonEngegarPararClick(Sender: TObject);
var
  i,n,k:LongInt;
  Rectangle:TRect;
begin
  if SpeedButtonEngegarParar.Down then begin
    IniciarDadesEntradaDeSo;
    //GrandariaBytesBufferEntradaDeSo:=512;
    GrandariaBytesBufferEntradaDeSo:=GrandariaInstant;
    BitsPerMostraEntradaSo:=16;
    FrequenciaDeMostreigEntradaSo:=11025;
    ComptadorPosicio:=0;
    Comptador:=0;
    HertzUnPuntEspectroscopi:=FrequenciaDeMostreigEntradaSo/511;
    {
    NumeroQuoeficientsLPC:=SpinEditNumeroQuoeficients.Value;
    if FrequenciaDeMostreigEntradaSo=22050 then begin
      NumeroQuoeficientsLPC:=2*NumeroQuoeficientsLPC;
    end else if FrequenciaDeMostreigEntradaSo=44100 then begin
      NumeroQuoeficientsLPC:=4*NumeroQuoeficientsLPC;
    end;
    }
    for i:=-MaximGrandariaInstant to MaximNumerosTotElSo do TotElSo[1,i]:=0;
    //for i:=-MaximGrandariaInstant to MaximNumerosTotElSo do TotElSo[2,i]:=0;
    for i:=0 to NumeroInstants do begin
      HiHaSo[1,i]:=0;
      //HiHaSo[2,i]:=0;
      for n:=1 to MaximNumerosBufferEntradaDeSo do begin
        //for k:=1 to 2 do EspectreY[k,i,n]:=0;
        EspectreY[1,i,n]:=0;
      end;
    end;
    Arrenco:=1;
    Rectangle.Left:=0;
    Rectangle.Top:=YComenssaEspectroscopi;
    Rectangle.Right:=Width;
    Rectangle.Bottom:=YComenssaEspectroscopi+257;
    InvalidateRect(Handle,@Rectangle,true);
    UpdateWindow(Handle);
    Arrenco:=0;
    NumeroPunts:=1600;
    if Screen.Width-1<NumeroPunts then NumeroPunts:=Screen.Width-1;
    if SpinEditVelocitat.Value=6 then begin
      IntervalEntreInstants:=16;
    end else if SpinEditVelocitat.Value=5 then begin
      IntervalEntreInstants:=32;
    end else if SpinEditVelocitat.Value=4 then begin
      IntervalEntreInstants:=64;
    end else if SpinEditVelocitat.Value=3 then begin
      IntervalEntreInstants:=128;
    end else if SpinEditVelocitat.Value=2 then begin
      IntervalEntreInstants:=256;
    end else if SpinEditVelocitat.Value=1 then begin
      IntervalEntreInstants:=512;
    end;
    Titol[1]:='';
    ValorMinimDeSo:=(StrToInt(FormCanviDeParametres.EditMinim.Text)*256) div 4;
    if EngegarProcesEntradaDeSo(Handle)=0 then begin
      SpeedButtonEngegarParar.Caption:='P';
      SpeedButtonEngegarPararGlobus.Enabled:=false;
      SpinEditVelocitat.Enabled:=false;
      SpinEditNumeroQuoeficients.Enabled:=false;
      CheckBoxEscalaY.Enabled:=false;
      QuinSo:=1;
      HeDeRepintar:=false;
    end;
    Temps:=GetTickCount;
    //Caption:='';
  end else begin
    FinalitzarEntradaDeSo;
    SpeedButtonEngegarParar.Caption:='E';
    SpeedButtonEngegarPararGlobus.Enabled:=true;
    SpinEditVelocitat.Enabled:=true;
    SpinEditNumeroQuoeficients.Enabled:=true;
    CheckBoxEscalaY.Enabled:=true;
    PintarEjes;
    HeDeRepintar:=true;
  end;
end;

procedure TFormSonograma.SpeedButtonEngegarPararGlobusClick(Sender: TObject);
var
  i,n:LongInt;
  Rectangle:TRect;
  Comodi:integer;
begin
  if SpeedButtonEngegarPararGlobus.Down then begin
    IniciarDadesEntradaDeSo;
    GrandariaBytesBufferEntradaDeSo:=512;
    BitsPerMostraEntradaSo:=16;
    FrequenciaDeMostreigEntradaSo:=11025;
    ComptadorPosicio:=0;
    Comptador:=0;
    HertzUnPuntEspectroscopi:=FrequenciaDeMostreigEntradaSo/511;
    {
    NumeroQuoeficientsLPC:=SpinEditNumeroQuoeficients.Value;
    if FrequenciaDeMostreigEntradaSo=22050 then begin
      NumeroQuoeficientsLPC:=2*NumeroQuoeficientsLPC;
    end else if FrequenciaDeMostreigEntradaSo=44100 then begin
      NumeroQuoeficientsLPC:=4*NumeroQuoeficientsLPC;
    end;
    }
    for i:=-MaximGrandariaInstant to MaximNumerosTotElSo do TotElSo[2,i]:=0;
    for i:=0 to NumeroInstants do begin
      HiHaSo[2,i]:=0;
      for n:=1 to MaximNumerosBufferEntradaDeSo do EspectreY[2,i,n]:=0;
    end;
    Arrenco:=2;
    Rectangle.Left:=0;
    Rectangle.Top:=YComenssaEspectroscopi+257;
    Rectangle.Right:=Width;
    Rectangle.Bottom:=Height;
    InvalidateRect(Handle,@Rectangle,true);
    UpdateWindow(Handle);
    Arrenco:=0;
    NumeroPunts:=1600;
    if Screen.Width-1<NumeroPunts then NumeroPunts:=Screen.Width-1;
    if SpinEditVelocitat.Value=6 then begin
      IntervalEntreInstants:=16;
    end else if SpinEditVelocitat.Value=5 then begin
      IntervalEntreInstants:=32;
    end else if SpinEditVelocitat.Value=4 then begin
      IntervalEntreInstants:=64;
    end else if SpinEditVelocitat.Value=3 then begin
      IntervalEntreInstants:=128;
    end else if SpinEditVelocitat.Value=2 then begin
      IntervalEntreInstants:=256;
    end else if SpinEditVelocitat.Value=1 then begin
      IntervalEntreInstants:=512;
    end;
    Titol[2]:='';
    ValorMinimDeSo:=(StrToInt(FormCanviDeParametres.EditMinim.Text)*256) div 4;
    if EngegarProcesEntradaDeSo(Handle)=0 then begin
      SpeedButtonEngegarPararGlobus.Caption:='PG';
      SpeedButtonEngegarParar.Enabled:=false;
      SpinEditVelocitat.Enabled:=false;
      SpinEditNumeroQuoeficients.Enabled:=false;
      CheckBoxEscalaY.Enabled:=false;
      QuinSo:=2;
      HeDeRepintar:=false;
    end;
  end else begin
    FinalitzarEntradaDeSo;
    SpeedButtonEngegarPararGlobus.Caption:='EG';
    SpeedButtonEngegarParar.Enabled:=true;
    SpinEditVelocitat.Enabled:=true;
    SpinEditNumeroQuoeficients.Enabled:=true;
    CheckBoxEscalaY.Enabled:=true;
    PintarEjes;
    HeDeRepintar:=true;
  end;
end;

procedure TFormSonograma.CheckBoxEscalaYClick(Sender: TObject);
begin
  Repaint;
  if CheckBoxEscalaY.Checked then
   writePrivateProfileString('Sonograma','EscalaY','SI','globus3.ini')
  else
   writePrivateProfileString('Sonograma','EscalaY','NO','globus3.ini')
end;

procedure TFormSonograma.SpinEditVelocitatChange(Sender: TObject);
begin
  writePrivateProfileString('Sonograma','Velocitat',PChar(IntToStr(SpinEditVelocitat.Value)),'globus3.ini')
end;

procedure TFormSonograma.CheckBoxCircularClick(Sender: TObject);
begin
  if CheckBoxCircular.Checked then
   writePrivateProfileString('Sonograma','Circular','SI','globus3.ini')
  else
   writePrivateProfileString('Sonograma','Circular','NO','globus3.ini')
end;

procedure TFormSonograma.FormMouseMove(Sender: TObject; Shift: TShiftState;X, Y: Integer);
var
  Freq:integer;
begin
  Freq:=0;
  if (y>(YComenssaEspectroscopi-1)) and  (y<(YComenssaEspectroscopi+256)) then begin
    //Freq:=Round((y-YComenssaEspectroscopi)*HertzUnPuntEspectroscopi);
    Freq:=Round((YComenssaEspectroscopi+255-y)*HertzUnPuntEspectroscopi);
  end else if (y>(YComenssaEspectroscopi+256)) and  (y<(YComenssaEspectroscopi+513)) then begin
    //Freq:=Round((y-(YComenssaEspectroscopi+257))*HertzUnPuntEspectroscopi);
    Freq:=Round(((YComenssaEspectroscopi+257+255)-y)*HertzUnPuntEspectroscopi);
  end;
  if Freq>0 then begin
    StaticTextFrequenciaMouseMove.Caption:=IntToStr(Freq)+'  Hz';
    StaticTextNotaMouseMove.Caption:=TornarNota(Freq);
  end;
end;

{************************************************}
procedure TFormSonograma.FormPaint(Sender: TObject);
var
  i:LongInt;
  n,k,Comodi:integer;
  R:Byte;
var
  ScreenDC: HDC;
begin
  if not HeDeRepintar then exit;
  //Temps:=GetTickCount;
  Canvas.Pen.Color:=clBlack;
  Canvas.MoveTo(0,YComenssaEspectroscopi-1);
  Canvas.LineTo(ClientWidth,YComenssaEspectroscopi-1);
  Canvas.MoveTo(0,YComenssaEspectroscopi+256);
  Canvas.LineTo(ClientWidth,YComenssaEspectroscopi+256);
  Canvas.MoveTo(0,YComenssaEspectroscopi+513);
  Canvas.LineTo(ClientWidth,YComenssaEspectroscopi+513);
  if Arrenco<>0 then exit;
  ScreenDC:=GetDC(Handle);
  for k:=1 to 2 do begin
    //if (Arrenco=2) and (k=2) then break;
    //if k=1 then Comodi:=YComenssaEspectroscopi else Comodi:=YComenssaEspectroscopi+257;
    if k=1 then Comodi:=YComenssaEspectroscopi+255 else Comodi:=YComenssaEspectroscopi+257+255;
    //for i:=0 to NumeroInstants do begin
    for i:=0 to NumeroPunts do begin
      if HiHaSo[k,i]=1 then begin
        //Canvas.MoveTo(i,Comodi);
        MoveToEx(ScreenDC,i,Comodi,nil);
        for n:=1 to NumerosEspectre do begin
          //r:=255-Round(EspectreY[k,i,n]);
          //Canvas.Pen.Color:=RGB(r,r,r);
          //Canvas.LineTo(i,Comodi+n);
          r:=Round(EspectreY[k,i,n]);
          SelectObject(ScreenDC,Pens[r]);
          //LineTo(ScreenDC,i,Comodi+n);
          LineTo(ScreenDC,i,Comodi-n);
        end;
      end;
    end;
    {
    if CheckBoxEscalaY.Checked then begin
      SelectObject(ScreenDC,PenGris);
      i:=5000;
      While i>500 do begin
        MoveToEx(ScreenDC,0,Comodi-Round(i/HertzUnPuntEspectroscopi),nil);
        LineTo(ScreenDC,width,Comodi-Round(i/HertzUnPuntEspectroscopi));
        Canvas.TextOut(3,Comodi-12-Round(i/HertzUnPuntEspectroscopi),IntToStr(i));
        i:=i-1000;
      end;
    end;
    }
  end;
  ReleaseDC(Handle,ScreenDC);
  PintarEjes;
  //Caption:=IntToStr(GetTickCount-Temps);
end;

procedure TFormSonograma.WMWIMDATA(var Msg: TMessage);
var
  i,Iinicial:LongInt;
  n,Comodi:integer;
  R:Byte;
var
  ScreenDC: HDC;
begin
  if ParoProcesContinuEntradaDeSo then exit;
  //Temps:=GetTickCount;
  ValorMaximDelSo:=ValorMaximDetectatEntradaDeSo;
  for i:=1 to GrandariaNumerosBufferEntradaDeSo do TotElSo[QuinSo,i+Comptador*GrandariaInstant]:=NumerosEntradaDeSo[i];
  Iinicial:=Comptador*GrandariaInstant-GrandariaInstant+IntervalEntreInstants;
  i:=Iinicial;
  //if QuinSo=1 then Comodi:=YComenssaEspectroscopi else Comodi:=YComenssaEspectroscopi+257;
  if QuinSo=1 then Comodi:=YComenssaEspectroscopi+255 else Comodi:=YComenssaEspectroscopi+257+255;
  ScreenDC:=GetDC(Handle);
  NumeroQuoeficientsLPC:=SpinEditNumeroQuoeficients.Value;
  if FrequenciaDeMostreigEntradaSo=22050 then begin
    NumeroQuoeficientsLPC:=2*NumeroQuoeficientsLPC;
  end else if FrequenciaDeMostreigEntradaSo=44100 then begin
    NumeroQuoeficientsLPC:=4*NumeroQuoeficientsLPC;
  end;
  while i-Iinicial<GrandariaInstant do begin
    for n:=1 to NumeroDeDadesInicialsLPC do NumerosPerCalcularFFT[n]:=TotElSo[QuinSo,n+i];
    ValorMaximDelSo:=0;
    for n:=1 to NumeroDeDadesInicialsLPC do if NumerosPerCalcularFFT[n]>ValorMaximDelSo then ValorMaximDelSo:=Round(NumerosPerCalcularFFT[n]);
    //if ValorMaximDelSo>15*256 then begin
    //if ValorMaximDelSo>10*256 then begin
    if ValorMaximDelSo>ValorMinimDeSo then begin
      CalcularPreenfasis(NumerosPerCalcularFFT,NumeroDeDadesInicialsLPC);
      CalcularFinestraDeHamming(NumerosPerCalcularFFT,NumeroDeDadesInicialsLPC);
      for n:=1 to NumeroDeDadesInicialsLPC do NumerosPerCalcularLPC[n-1]:=NumerosPerCalcularFFT[n];
      CalculFuncioTransferenciaLPC(NumeroDeDadesInicialsLPC,NumerosPerCalcularLPC,NumeroQuoeficientsLPC,NumeroPuntsFuncioDeTransferencia,FuncioDeTransferenciaLPCX,FuncioDeTransferenciaLPCY);
      NormalitzarQuoeficientsPerMaxim(NumeroPuntsFuncioDeTransferencia,255,FuncioDeTransferenciaLPCY);
      for n:=1 to NumerosEspectre do EspectreY[QuinSo,ComptadorPosicio,n]:=FuncioDeTransferenciaLPCY[n];
      HiHaSo[QuinSo,ComptadorPosicio]:=1;
    end else begin
      for n:=1 to NumerosEspectre do EspectreY[QuinSo,ComptadorPosicio,n]:=0;
      HiHaSo[QuinSo,ComptadorPosicio]:=0;
    end;
    //Canvas.MoveTo(ComptadorPosicio,Comodi);
    MoveToEx(ScreenDC,ComptadorPosicio,Comodi,nil);
    for n:=1 to NumerosEspectre do begin
      {
      r:=255-Round(EspectreY[QuinSo,ComptadorPosicio,n]);
      Canvas.Pen.Color:=RGB(r,r,r);
      Canvas.LineTo(ComptadorPosicio,Comodi+n);
      }
      r:=Round(EspectreY[QuinSo,ComptadorPosicio,n]);
      SelectObject(ScreenDC,Pens[r]);
      //LineTo(ScreenDC,ComptadorPosicio,Comodi+n);
      LineTo(ScreenDC,ComptadorPosicio,Comodi-n);

    end;
    inc(ComptadorPosicio);
    i:=i+IntervalEntreInstants;
    {
    Canvas.Pen.Color:=ClRed;
    Canvas.MoveTo(ComptadorPosicio,Comodi);
    Canvas.LineTo(ComptadorPosicio,Comodi+NumerosEspectre);
    }
    SelectObject(ScreenDC,PenVermell);
    MoveToEx(ScreenDC,ComptadorPosicio+1,Comodi,nil);
    //LineTo(ScreenDC,ComptadorPosicio+1,Comodi+NumerosEspectre);
    LineTo(ScreenDC,ComptadorPosicio+1,Comodi-NumerosEspectre);
  end;
  ReleaseDC(Handle,ScreenDC);
  //if ComptadorPosicio>=NumeroInstants then begin
  if ComptadorPosicio>=NumeroPunts then begin
    if CheckBoxCircular.Checked then begin
      ComptadorPosicio:=0;
    end else begin
      if QuinSo=1 then begin
        FinalitzarEntradaDeSo;
        //Caption:=IntToStr(GetTickCount-Temps);
        SpeedButtonEngegarParar.Caption:='E';
        SpeedButtonEngegarParar.Down:=false;
        SpeedButtonEngegarPararGlobus.Enabled:=true;
      end else begin
        FinalitzarEntradaDeSo;
        SpeedButtonEngegarPararGlobus.Caption:='EG';
        SpeedButtonEngegarPararGlobus.Down:=false;
        SpeedButtonEngegarParar.Enabled:=true;
      end;
      SpinEditVelocitat.Enabled:=true;
      SpinEditNumeroQuoeficients.Enabled:=true;
      CheckBoxEscalaY.Enabled:=true;
      HeDeRepintar:=true;
    end;
    {
    if CheckBoxEscalaY.Checked then begin
      Canvas.Pen.Color:=ClGray;
      i:=5000;
      While i>500 do begin
        Canvas.MoveTo(0,Comodi-Round(i/HertzUnPuntEspectroscopi));
        Canvas.LineTo(width,Comodi-Round(i/HertzUnPuntEspectroscopi));
        Canvas.TextOut(3,Comodi-12-Round(i/HertzUnPuntEspectroscopi),IntToStr(i));
        i:=i-1000;
      end;
    end;
    }
    PintarEjes;
  end;
  inc(Comptador);
  //Caption:=IntToStr(GetTickCount-Temps);
end;

procedure TFormSonograma.GuardarPista(Pista:integer);
var
  i:LongInt;
  Nom:string;
  TS:TStringList;
  //TS:TFileStream;
  //S:string;
begin
  if Comptador>0 then begin
    TS:=TStringList.Create;
    TS.Sorted:=false;
    TS.Add('Globus 3 - Projecte Fressa - (C) Jordi Lagares Roset - www.lagares.org');
    TS.Add(AboutBox.Version.Caption);
    TS.Add('Sonograma');
    TS.Add(IntToStr(Comptador));
    TS.Add(IntToStr(NumeroQuoeficientsLPC));
    TS.Add(IntToStr(SpinEditVelocitat.Value));
    for i:=1 to Comptador*GrandariaInstant do TS.Add(IntToStr(TotElSo[Pista,i]));
    if SaveDialog.Execute then begin
      Nom:=SaveDialog.Filename;
      if Pos('.',Copy(Nom,length(Nom)-10,11))=0 then Nom:=Nom+'.sonoglobus';
      TS.SaveToFile(nom);
    end;
    TS.Free;
  end;
  {
  if Comptador>0 then begin
    if SaveDialog.Execute then begin
      Nom:=SaveDialog.Filename;
      if Pos('.',Copy(Nom,length(Nom)-10,11))=0 then Nom:=Nom+'.sonoglobus';
      TS:=TFileStream.Create(Nom,fmCreate);
      S:='Globus 3 - Projecte Fressa - (C) Jordi Lagares Roset - www.lagares.org';
      S:=S+AboutBox.Version.Caption;
      S:=S+IntToStr(Comptador);
      S:=S+IntToStr(NumeroQuoeficientsLPC);
      S:=S+IntToStr(SpinEditVelocitat.Value);
      for i:=1 to Comptador*GrandariaInstant do S:=S+chr(Hi(TotElSo[Pista,i]))+chr(Lo(TotElSo[Pista,i]));
      try
        TS.WriteBuffer(Pointer(S)^, Length(S));
      finally
        TS.Free;
      end;
    end;
  end;
  }
end;

procedure TFormSonograma.ButtonGuardarPista1Click(Sender: TObject);
begin
  GuardarPista(1);
end;

procedure TFormSonograma.ButtonGuardarPista2Click(Sender: TObject);
begin
  GuardarPista(2);
end;

procedure TFormSonograma.ObrirPista(Pista:integer);
var
  i,n,k,Iinicial:LongInt;
  Nom:string;
  TS:TStringList;
  ComptadorFinal:integer;
  Velocitat:integer;
  NumCoef:integer;
  Versio:string;
  EsCorrecte:integer;
begin
  if OpenDialog.Execute then begin
    TS:=TStringList.Create;
    TS.Sorted:=false;
    Nom:=OpenDialog.Filename;
    TS.LoadFromFile(nom);
    Nom:=ExtractFileName(Nom);
    EsCorrecte:=0;
    try
      if TS.Strings[0]<>'Globus 3 - Projecte Fressa - (C) Jordi Lagares Roset - www.lagares.org' then EsCorrecte:=1;
      if EsCorrecte=0 then begin
        Versio:=TS.Strings[1];
        if TS.Strings[2]<>'Sonograma' then EsCorrecte:=2;
      end;
      if EsCorrecte=0 then begin
        ComptadorFinal:=StrToInt(TS.Strings[3]);
        if ComptadorFinal<=0 then EsCorrecte:=3;
      end;
      if EsCorrecte=0 then begin
        NumCoef:=StrToInt(TS.Strings[4]);
        Velocitat:=StrToInt(TS.Strings[5]);
        if not((NumCoef>=SpinEditNumeroQuoeficients.MinValue) and (NumCoef<=SpinEditNumeroQuoeficients.MaxValue) and (SpinEditVelocitat.Value>=SpinEditVelocitat.MinValue) and (SpinEditVelocitat.Value<=SpinEditVelocitat.MaxValue)) then EsCorrecte:=4;
      end;
    except
      EsCorrecte:=5;
    end;
    if EsCorrecte=0 then begin
      try
        for i:=6 to ComptadorFinal*GrandariaInstant+5 do TotElSo[Pista,i-5]:=StrToInt(TS.Strings[i]);
        QuinSo:=Pista;
        NumeroQuoeficientsLPC:=NumCoef;
        HeDeReCalcularLPC:=false;
        SpinEditNumeroQuoeficients.Value:=NumeroQuoeficientsLPC;
        if FrequenciaDeMostreigEntradaSo=22050 then begin
          NumeroQuoeficientsLPC:=2*NumeroQuoeficientsLPC;
        end else if FrequenciaDeMostreigEntradaSo=44100 then begin
          NumeroQuoeficientsLPC:=4*NumeroQuoeficientsLPC;
        end;
        SpinEditVelocitat.Value:=Velocitat;
        if SpinEditVelocitat.Value=6 then begin
          IntervalEntreInstants:=16;
        end else if SpinEditVelocitat.Value=5 then begin
          IntervalEntreInstants:=32;
        end else if SpinEditVelocitat.Value=4 then begin
          IntervalEntreInstants:=64;
        end else if SpinEditVelocitat.Value=3 then begin
          IntervalEntreInstants:=128;
        end else if SpinEditVelocitat.Value=2 then begin
          IntervalEntreInstants:=256;
        end else if SpinEditVelocitat.Value=1 then begin
          IntervalEntreInstants:=512;
        end;
        Cursor:=CrHourGlass;
        ComptadorPosicio:=0;
        for k:=0 to ComptadorFinal-1 do begin
          Comptador:=k;
          Iinicial:=Comptador*GrandariaInstant-GrandariaInstant+IntervalEntreInstants;
          i:=Iinicial;
          while i-Iinicial<GrandariaInstant do begin
            for n:=1 to NumeroDeDadesInicialsLPC do NumerosPerCalcularFFT[n]:=TotElSo[Pista,n+i];
            ValorMaximDelSo:=0;
            for n:=1 to NumeroDeDadesInicialsLPC do if NumerosPerCalcularFFT[n]>ValorMaximDelSo then ValorMaximDelSo:=Round(NumerosPerCalcularFFT[n]);
            if ValorMaximDelSo>ValorMinimDeSo then begin
              CalcularPreenfasis(NumerosPerCalcularFFT,NumeroDeDadesInicialsLPC);
              CalcularFinestraDeHamming(NumerosPerCalcularFFT,NumeroDeDadesInicialsLPC);
              for n:=1 to NumeroDeDadesInicialsLPC do NumerosPerCalcularLPC[n-1]:=NumerosPerCalcularFFT[n];
              CalculFuncioTransferenciaLPC(NumeroDeDadesInicialsLPC,NumerosPerCalcularLPC,NumeroQuoeficientsLPC,NumeroPuntsFuncioDeTransferencia,FuncioDeTransferenciaLPCX,FuncioDeTransferenciaLPCY);
              NormalitzarQuoeficientsPerMaxim(NumeroPuntsFuncioDeTransferencia,255,FuncioDeTransferenciaLPCY);
              for n:=1 to NumerosEspectre do EspectreY[QuinSo,ComptadorPosicio,n]:=FuncioDeTransferenciaLPCY[n];
              HiHaSo[QuinSo,ComptadorPosicio]:=1;
            end else begin
              for n:=1 to NumerosEspectre do EspectreY[QuinSo,ComptadorPosicio,n]:=0;
              HiHaSo[QuinSo,ComptadorPosicio]:=0;
            end;
            inc(ComptadorPosicio);
            i:=i+IntervalEntreInstants;
            if ComptadorPosicio>=NumeroPunts then begin
              inc(Comptador);
              dec(ComptadorPosicio);
              Titol[Pista]:=Nom;
              Repaint;
              TS.Free;
              Cursor:=CrDefault;
              exit;
            end;
          end;
        end;
        inc(Comptador);
        Cursor:=CrDefault;
      except
        EsCorrecte:=6;
        for i:=-MaximGrandariaInstant to MaximNumerosTotElSo do begin
          //TotElSo[1,i]:=0;
          //TotElSo[2,i]:=0;
          TotElSo[Pista,i]:=0;
        end;
        for i:=0 to NumeroInstants do begin
          {
          HiHaSo[1,i]:=0;
          HiHaSo[2,i]:=0;
          for n:=1 to MaximNumerosBufferEntradaDeSo do for k:=1 to 2 do EspectreY[k,i,n]:=0;
          }
          HiHaSo[Pista,i]:=0;
          for n:=1 to MaximNumerosBufferEntradaDeSo do EspectreY[Pista,i,n]:=0;
        end;
        Titol[Pista]:='';
      end;
      Titol[Pista]:=Nom;
      Repaint;
    end;
    TS.Free;
    if EsCorrecte>0 then ShowMessage(Caption+'. '+FormPrincipal.Missatges[1]+'. Error n: '+IntToStr(EsCorrecte));
  end;
end;

procedure TFormSonograma.SpeedButtonObrir1Click(Sender: TObject);
begin
  ObrirPista(1);
end;

procedure TFormSonograma.SpeedButtonObrir2Click(Sender: TObject);
begin
  ObrirPista(2);
end;

procedure TFormSonograma.SpinEditNumeroQuoeficientsChange(Sender: TObject);
var
  i,n,k,h,Iinicial:LongInt;
  ComptadorFinal:integer;
begin
  if not HeDeReCalcularLPC then begin
    HeDeReCalcularLPC:=true;
    exit;
  end;
  Cursor:=CrHourGlass;
  NumeroQuoeficientsLPC:=SpinEditNumeroQuoeficients.Value;
  if FrequenciaDeMostreigEntradaSo=22050 then begin
    NumeroQuoeficientsLPC:=2*NumeroQuoeficientsLPC;
  end else if FrequenciaDeMostreigEntradaSo=44100 then begin
    NumeroQuoeficientsLPC:=4*NumeroQuoeficientsLPC;
  end;
  ComptadorFinal:=Comptador;
  for h:=1 to 2 do begin
    ComptadorPosicio:=0;
    for k:=0 to ComptadorFinal-1 do begin
      Comptador:=k;
      Iinicial:=Comptador*GrandariaInstant-GrandariaInstant+IntervalEntreInstants;
      i:=Iinicial;
      while i-Iinicial<GrandariaInstant do begin
        for n:=1 to NumeroDeDadesInicialsLPC do NumerosPerCalcularFFT[n]:=TotElSo[h,n+i];
        ValorMaximDelSo:=0;
        for n:=1 to NumeroDeDadesInicialsLPC do if NumerosPerCalcularFFT[n]>ValorMaximDelSo then ValorMaximDelSo:=Round(NumerosPerCalcularFFT[n]);
        if ValorMaximDelSo>ValorMinimDeSo then begin
          CalcularPreenfasis(NumerosPerCalcularFFT,NumeroDeDadesInicialsLPC);
          CalcularFinestraDeHamming(NumerosPerCalcularFFT,NumeroDeDadesInicialsLPC);
          for n:=1 to NumeroDeDadesInicialsLPC do NumerosPerCalcularLPC[n-1]:=NumerosPerCalcularFFT[n];
          CalculFuncioTransferenciaLPC(NumeroDeDadesInicialsLPC,NumerosPerCalcularLPC,NumeroQuoeficientsLPC,NumeroPuntsFuncioDeTransferencia,FuncioDeTransferenciaLPCX,FuncioDeTransferenciaLPCY);
          NormalitzarQuoeficientsPerMaxim(NumeroPuntsFuncioDeTransferencia,255,FuncioDeTransferenciaLPCY);
          for n:=1 to NumerosEspectre do EspectreY[h,ComptadorPosicio,n]:=FuncioDeTransferenciaLPCY[n];
          HiHaSo[h,ComptadorPosicio]:=1;
        end else begin
          for n:=1 to NumerosEspectre do EspectreY[h,ComptadorPosicio,n]:=0;
          HiHaSo[h,ComptadorPosicio]:=0;
        end;
        inc(ComptadorPosicio);
        i:=i+IntervalEntreInstants;
      end;
    end;
  end;
  Comptador:=ComptadorFinal;
  Repaint;
  writePrivateProfileString('Sonograma','Numero de quoeficients',PChar(IntToStr(SpinEditNumeroQuoeficients.Value)),'globus3.ini');
  Cursor:=CrDefault;
end;

procedure TFormSonograma.SpeedButtonCaixaEinesClick(Sender: TObject);
begin
  FormCanviDeParametres.ShowModal;
end;

procedure TFormSonograma.FormMouseDown(Sender: TObject;Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  i,Comodi:integer;
begin
  if Button=mbleft then begin
  end else begin
    if SpeedButtonEngegarParar.Down or SpeedButtonEngegarPararGlobus.Down then begin
      FinalitzarEntradaDeSo;
      SpeedButtonEngegarParar.Caption:='E';
      SpeedButtonEngegarParar.Down:=false;
      SpeedButtonEngegarParar.Enabled:=true;
      SpeedButtonEngegarPararGlobus.Caption:='EG';
      SpeedButtonEngegarPararGlobus.Down:=false;
      SpeedButtonEngegarPararGlobus.Enabled:=true;
      SpinEditVelocitat.Enabled:=true;
      SpinEditNumeroQuoeficients.Enabled:=true;
      CheckBoxEscalaY.Enabled:=true;
      PintarEjes;
      HeDeRepintar:=true;
    end;
  end;
end;


end.
